# AI Assistant for AI plugin in Only Office

## 🚀 Overview

Welcome to the AI Assistant Plugin – your intelligent writing companion! This powerful plugin allows you to create custom AI assistants that analyze your documents for specific issues and suggest improvements. Whether you need fact-checking, style improvements, or specialized text analysis, you can now build AI helpers tailored to your exact needs.

### 🎯 **Three Assistant Types**

Choose how assistants interact with your text:

| Type | Action | Best For |
|------|--------|----------|
| **Hint** | Shows explanation why text was highlighted | Learning, suggestions without direct edits |
| **Replace** | Offers replacement with simple accept/reject | Quick fixes, consistent terminology |
| **Replace + Hint** | Provides both replacement and detailed explanation | Complex edits needing justification |

### 🔗 **Smart Source Linking**

If your assistant prompt requests sources/links:

- Clickable URLs appear in popup windows
- Sources support your assistant's suggestions
- Links open in new tabs automatically

### ⚡ **Smart Text Selection**

- **With selection**: If text is selected when activating an assistant, only selected paragraphs are analyzed
- **Without selection**: If no text is selected, the entire document is analyzed
- **Dynamic updates**: Edited paragraphs are automatically re-analyzed

## 🚀 Getting Started

### Creating Your First Assistant

1. **Open the AI Plugin Panel**
   - Click the AI icon in your editor toolbar

2. **Create a New Assistant**
   - Click **"Create AI assistant"** button
   - Fill in the creation form:
     - **Name**: Give your assistant a descriptive name
     - **Type**: Choose Hint, Replace, or Replace+Hint
     - **Description/Prompt**: Write clear instructions for what to look for

3. **Example Prompts:**

- "Find all incorrect dates in historical documents and suggest corrections"
- "Replace all examples of youth slang and informal language in the text.  
    Look for:
    1. Modern slang terms (like "lit", "savage", "flex", "GOAT")
    2. Internet memes and viral expressions
    3. Common abbreviations ("LOL", "BRB", "IMO", "TBH")
    4. English borrowings used in informal contexts
    5. Colloquial expressions and trendy phrases"
- "Check for consistency in character names throughout this novel"
- "Verify scientific facts against current research with source links"

### Using Assistants  

**1. Activate an Assistant**  

- Click the assistant's icon to enable it
- Click again to disable it

**2. Review Findings**  

- Text matches appear highlighted in your document
- Click highlighted text to see assistant's suggestions
- Choose to accept or reject suggestions
  
**3. Multiple Assistants**  

- Run multiple assistants simultaneously
- Each uses different colors for easy identification

## 📋 Assistant Types in Detail

### **Type 1: Hint**

- Text is highlighted for your attention
- Click to see **why** it was flagged
- No automatic changes – you decide what to do
- **Best for**: Learning, awareness, suggestions

### **Type 2: Replace**  

- Text is highlighted with suggested replacement
- Click to see the **replacement dialog**
- Accept or reject with one click
- **Best for**: Quick fixes, consistent terminology

### **Type 3: Replace + Hint**  

- Combines both replacement and explanation
- Click to see **replacement dialog with detailed reasoning**
- Includes source links if requested
- **Best for**: Complex edits, fact-checking, learning

## 🔧 Managing Assistants

### **Edit an Assistant**  

If an assistant isn't working as expected:

1. Open the Assistant icon's drop-down menu
2. Click "Edit" next to the assistant
3. Refine the prompt or change the type
4. Save changes

### **Delete an Assistant**

1. Open the Assistant icon's drop-down menu
2. Click "Delete" next to the assistant
3. Confirm deletion

## 💡 Best Practices for Writing Prompts

### **Be Specific**

✅ GOOD: "Find dates before 1900 that might be incorrect"  
❌ VAGUE: "Check for wrong dates"

✅ AUDIENCE-AWARE: "Simplify technical jargon for general readers"  
❌ GENERIC: "Make text easier to read"

> 💡 **Pro Tip**: The most effective assistants are those with clear, specific instructions. Don't be afraid to experiment – you can always edit or delete assistants that don't work as expected!

---
*We can't wait to see what amazing assistants you'll create! Your creativity will help shape the future of this feature.*